import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 29.03.2013
  * @author
  */

public class RSA_Anwendung extends JFrame {
  // Anfang Attribute
  long n, nm, d, e;
  String klarText, verText;
  String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890.,;!?";
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JNumberField nfPrimzahl = new JNumberField();
  private JLabel jLabel3 = new JLabel();
  private JButton btPrimzahltest = new JButton();
  private JLabel lbPrimzahlErgebnis = new JLabel();
  private JLabel jLabel4 = new JLabel();
  private JNumberField nfPZ1 = new JNumberField();
  private JNumberField nfPZ2 = new JNumberField();
  private JButton btErzeugeModule = new JButton();
  private JLabel jLabel5 = new JLabel();
  private JLabel jLabel51 = new JLabel();
  private JLabel lbHauptmodul = new JLabel();
  private JLabel lbNebenmodul = new JLabel();
  private JLabel lbFrage = new JLabel();
  private JLabel jLabel6 = new JLabel();
  private JLabel jLabel61 = new JLabel();
  private JLabel jLabel62 = new JLabel();
  private JNumberField nfVerschluesselung = new JNumberField();
  private JButton btGeeignet = new JButton();
  private JLabel lbAntwortGeeignet = new JLabel();
  private JLabel jLabel63 = new JLabel();
  private JLabel jLabel64 = new JLabel();
  private JButton btSucheD = new JButton();
  private JLabel lbAntwortD = new JLabel();
  private JLabel jLabel65 = new JLabel();
  private JTextField tfKlartext = new JTextField();
  private JButton btVerschluessele = new JButton();
  private JButton btEntschluessele = new JButton();
  private JLabel lbVerschluesselt = new JLabel();
  private JLabel lbEntschluesselt = new JLabel();
  // Ende Attribute
  
  public RSA_Anwendung(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 901; 
    int frameHeight = 552;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jLabel1.setBounds(20, 13, 256, 27);
    jLabel1.setText("Das RSA - Verfahren");
    jLabel1.setFont(new Font("Dialog", Font.BOLD, 24));
    cp.add(jLabel1);
    jLabel2.setBounds(24, 64, 203, 33);
    jLabel2.setText("Primzahltester:    Ist");
    jLabel2.setFont(new Font("Dialog", Font.BOLD, 15));
    cp.add(jLabel2);
    nfPrimzahl.setBounds(240, 64, 113, 33);
    nfPrimzahl.setText("223");
    cp.add(nfPrimzahl);
    jLabel3.setBounds(368, 64, 139, 33);
    jLabel3.setText("eine Primzahl ");
    jLabel3.setFont(new Font("Dialog", Font.BOLD, 15));
    cp.add(jLabel3);
    btPrimzahltest.setBounds(520, 64, 41, 33);
    btPrimzahltest.setText("?");
    btPrimzahltest.setMargin(new Insets(2, 2, 2, 2));
    btPrimzahltest.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btPrimzahltest_ActionPerformed(evt);
      }
    });
    cp.add(btPrimzahltest);
    lbPrimzahlErgebnis.setBounds(576, 64, 123, 33);
    lbPrimzahlErgebnis.setText("-              ");
    lbPrimzahlErgebnis.setFont(new Font("Dialog", Font.BOLD, 15));
    cp.add(lbPrimzahlErgebnis);
    jLabel4.setBounds(20, 108, 243, 27);
    jLabel4.setText("Geben Sie zwei Primzahlen an:");
    jLabel4.setFont(new Font("Dialog", Font.BOLD, 15));
    cp.add(jLabel4);
    nfPZ1.setBounds(282, 108, 98, 27);
    nfPZ1.setText("211");
    cp.add(nfPZ1);
    nfPZ2.setBounds(393, 108, 104, 27);
    nfPZ2.setText("223");
    cp.add(nfPZ2);
    btErzeugeModule.setBounds(24, 152, 97, 33);
    btErzeugeModule.setText("Erzeuge");
    btErzeugeModule.setMargin(new Insets(2, 2, 2, 2));
    btErzeugeModule.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btErzeugeModule_ActionPerformed(evt);
      }
    });
    cp.add(btErzeugeModule);
    jLabel5.setBounds(128, 152, 165, 33);
    jLabel5.setText("Hauptmodul (N): ");
    jLabel5.setFont(new Font("Dialog", Font.BOLD, 15));
    cp.add(jLabel5);
    jLabel51.setBounds(392, 152, 180, 33);
    jLabel51.setText("Nebenmodul(NM): ");
    cp.add(jLabel51);
    lbHauptmodul.setBounds(296, 152, 85, 33);
    lbHauptmodul.setText("-");
    cp.add(lbHauptmodul);
    lbNebenmodul.setBounds(576, 152, 85, 33);
    lbNebenmodul.setText("-");
    cp.add(lbNebenmodul);
    lbFrage.setBounds(664, 152, 219, 33);
    lbFrage.setText("(N>Alphabetlnge(42)?");
    cp.add(lbFrage);
    jLabel6.setBounds(24, 200, 867, 25);
    jLabel6.setText("Der Verschlsselungsexponent darf mit dem Nebenmodul keinen gemeinsamen Teiler haben,");
    jLabel6.setFont(new Font("Dialog", Font.BOLD, 15));
    cp.add(jLabel6);
    jLabel61.setBounds(24, 224, 867, 25);
    jLabel61.setText("damit der Entschlsselungsexponent berechnet werden kann.");
    cp.add(jLabel61);
    jLabel62.setBounds(24, 256, 467, 25);
    jLabel62.setText("Geben Sie einen Verschlsselungsexponenten an:");
    cp.add(jLabel62);
    nfVerschluesselung.setBounds(504, 256, 83, 28);
    nfVerschluesselung.setText("");
    cp.add(nfVerschluesselung);
    btGeeignet.setBounds(600, 256, 89, 33);
    btGeeignet.setText("geeignet ?");
    btGeeignet.setMargin(new Insets(2, 2, 2, 2));
    btGeeignet.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btGeeignet_ActionPerformed(evt);
      }
    });
    cp.add(btGeeignet);
    lbAntwortGeeignet.setBounds(696, 256, 83, 25);
    lbAntwortGeeignet.setText("-");
    cp.add(lbAntwortGeeignet);
    jLabel63.setBounds(24, 288, 867, 25);
    jLabel63.setText("Das Programm sucht automatisch den passenden Entschlsselungsexponenten (D).");
    cp.add(jLabel63);
    jLabel64.setBounds(24, 320, 867, 25);
    jLabel64.setText("Bedingung: D*E muss beim Teilen durch N den Rest 1 haben.");
    cp.add(jLabel64);
    btSucheD.setBounds(24, 352, 113, 33);
    btSucheD.setText("Suche  D");
    btSucheD.setMargin(new Insets(2, 2, 2, 2));
    btSucheD.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btSucheD_ActionPerformed(evt);
      }
    });
    cp.add(btSucheD);
    lbAntwortD.setBounds(152, 352, 123, 25);
    lbAntwortD.setText("-");
    cp.add(lbAntwortD);
    jLabel65.setBounds(24, 392, 443, 25);
    jLabel65.setText("Ein Text zum Testen (Grobuchstaben, Ziffern) :");
    cp.add(jLabel65);
    tfKlartext.setBounds(488, 392, 361, 33);
    tfKlartext.setText("INFORMATIK2013");
    cp.add(tfKlartext);
    btVerschluessele.setBounds(24, 424, 113, 33);
    btVerschluessele.setText("Verschlssele");
    btVerschluessele.setMargin(new Insets(2, 2, 2, 2));
    btVerschluessele.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btVerschluessele_ActionPerformed(evt);
      }
    });
    cp.add(btVerschluessele);
    btEntschluessele.setBounds(24, 472, 113, 33);
    btEntschluessele.setText("Entschlssele");
    btEntschluessele.setMargin(new Insets(2, 2, 2, 2));
    btEntschluessele.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btEntschluessele_ActionPerformed(evt);
      }
    });
    cp.add(btEntschluessele);
    lbVerschluesselt.setBounds(152, 424, 723, 25);
    lbVerschluesselt.setText("-");
    cp.add(lbVerschluesselt);
    lbEntschluesselt.setBounds(152, 472, 355, 25);
    lbEntschluesselt.setText("-");
    cp.add(lbEntschluesselt);
    // Ende Komponenten
    
    setVisible(true);
  } // end of public RSA_Anwendung
  
  // Anfang Methoden
  private boolean testPrimzahl (long p){
    boolean ist; long i;
    
    ist = true; i = 2;
    while (ist && (i <= Math.sqrt(p))) {
      if (p % i == 0) ist = false;
      i++;
    } // end of while
    return ist;
  }
  
  public void btPrimzahltest_ActionPerformed(ActionEvent evt) {
    if (testPrimzahl(nfPrimzahl.getLong())) {
      lbPrimzahlErgebnis.setText("Ja");
    } else lbPrimzahlErgebnis.setText("Nein");
    
  } // end of btPrimzahltest_ActionPerformed
  
  public void btErzeugeModule_ActionPerformed(ActionEvent evt) {
    long p1, p2;
    p1 = nfPZ1.getLong();
    p2 = nfPZ2.getLong();
    n = p1 * p2;
    nm = (p1-1) * (p2-1);
    lbHauptmodul.setText(Long.toString(n));
    lbNebenmodul.setText(Long.toString(nm));
  } // end of btErzeugeModule_ActionPerformed
  
  private long ggT (long a, long b){
    while (!(a == b)) {
      if (a < b)
      b = b - a;
      else a = a - b;
    } // end of while
    return a;
  }
  
  public void btGeeignet_ActionPerformed(ActionEvent evt) {
    e = nfVerschluesselung.getLong();
    if (ggT(e, nm) == 1)
    lbAntwortGeeignet.setText("Ja");
    else lbAntwortGeeignet.setText("Nein");
  } // end of btGeeignet_ActionPerformed
  
  public void btSucheD_ActionPerformed(ActionEvent evt) {
    int i = 1;
    d = 0;
    while ((i < nm) && (!((i*e) % nm == 1))) i++;
    if (i < nm)  d = i;
    if (d > 0) lbAntwortD.setText(Long.toString(d));
    else  lbAntwortD.setText("Nicht gefunden");
  } // end of btSucheD_ActionPerformed
  
  private long potmod (long basis, long exp, long modul){
    long i, pot;
    pot = 1;
    if (exp > 0) {
      for (i = 1 ;i <= exp ; i++ ) {
        pot = (pot * basis) % modul;
      } // end of for
    } // end of if
    return pot;
  }
  
  public void btVerschluessele_ActionPerformed(ActionEvent evt) {
    long nr, vnr;
    klarText = tfKlartext.getText();
    verText = "";
    for (int i=0; i< klarText.length() ; i++ ) {
      nr = alphabet.indexOf( klarText.substring(i, i+1));
      if (nr > -1) {
        vnr = potmod (nr, e, n);
        verText = verText + Long.toString(vnr) + ";";
      } // end of if
      
    } // end of for
    lbVerschluesselt.setText(verText);
  } // end of btVerschluessele_ActionPerformed
  
  
  public void btEntschluessele_ActionPerformed(ActionEvent evt) {
    long ver, ent;
    String entText = "";
    
    String[] zahlen  =  verText.split(";");
    for (int i=0; i<zahlen.length ; i++ ) {
      ver = Long.parseLong( zahlen[i]);
      ent = potmod(ver, d, n);
      if (ent < alphabet.length()) {
        entText = entText + alphabet.charAt((int)ent);
      } // end of if
      else {
        entText = entText + "$";
      } // end of if-else
    }
    lbEntschluesselt.setText(entText);
  } // end of btEntschluessele_ActionPerformed
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new RSA_Anwendung("RSA_Anwendung");
  } // end of main
  
  } // end of class RSA_Anwendung
